﻿using System;
using System.Collections;
using System.Web.UI;
using Soneta.Kadry;
using Soneta.Business;
using Soneta.Types;
using Soneta.Tools;
using Soneta.Kasa;
using Soneta.Web.Business.App;
using Soneta.Web.Business.Kadry;
using System.Collections.Generic;

namespace ASP {

    public partial class Pracownicy_Lista_Pelna : System.Web.UI.Page {

        public string Str_CultureInfo = "pl-PL";
        public string Str_OkresAll = "(wszystko)";
        public string Str_Minimalna = "minimum";
        public string Str_Mlodocianych = "pracowników młodocianych";
        public string Str_Pracownikow = "pracowników etatowych";
        public string Str_Wszystkich = "wszystkich pracowników";
        public string Str_Zatrudnionych = "Zatrudnionych w okresie";
        public string Str_Przyjetych = "Przyjętych do pracy w okresie";
        public string Str_Zwolnionych = "Zwolnionych z pracy w okresie";

        //Wspólny kod dla pracownicy - ewidencja, lista skrócona i lista pełna    
        [DefaultWidth(20)]
        [Caption("Filtr")]
        public enum Filtr {
            Wszyscy,
            Pracownicy,
            PracownicyMłodociani,
        }

        [DefaultWidth(20)]
        public enum Zakres {
            Wszyscy, 
            Przyjęci, 
            Zwolnieni,
        }

        public class PrnParams : Soneta.Business.ContextBase {

            public PrnParams(Context context) : base(context) {
            }

            Filtr filtr = Filtr.Pracownicy;
            [Priority(1)]
            [Caption("Filtr")]
            public Filtr Filtr {
                get { return filtr; }
                set {
                    filtr = value;
                    OnChanged(System.EventArgs.Empty);
                }
            }

            Zakres zakres;
            [Priority(2)]
            [Caption("Zakres")]
            public Zakres Zakres {
                get { return zakres; }
                set {
                    zakres = value;
                    OnChanged(System.EventArgs.Empty);
                }
            }

            bool przedluzenia = true;
            [Priority(3)]
            [Caption("Uwzgl. przedłużenia")]
            public bool Przedluzenia {
                get { return przedluzenia; }
                set {
                    przedluzenia = value;
                    OnChanged(System.EventArgs.Empty);
                }
            }

            public bool Test(Pracownik idx, Date data, FromTo okres) {
                bool bb = true;
                if (Filtr != Filtr.Wszyscy || Zakres != Zakres.Wszyscy) {
                    PracHistoria historia = idx[data];
                    switch (Zakres) {
                        case Zakres.Przyjęci:
                            FromTo zatr1 = !Przedluzenia ? historia.Etat.Okres : historia.Etat.OkresZatrudnienia;
                            bb &= okres.Contains(zatr1.From);
                            break;
                        case Zakres.Zwolnieni:
                            FromTo zatr2 = !Przedluzenia ? historia.Etat.Okres : historia.Etat.OkresZatrudnienia;
                            bb &= okres.Contains(zatr2.To);
                            break;
                    }
                    switch (Filtr) {
                        case Filtr.Pracownicy:
                            bb &= !Młodociany(historia.Etat.RodzajZatrudnienia);
                            break;
                        case Filtr.PracownicyMłodociani:
                            bb &= Młodociany(historia.Etat.RodzajZatrudnienia);
                            break;
                    }
                }
                return bb;
            }

            static bool Młodociany(RodzajZatrudnienia rodzaj) {
                switch (rodzaj) {
                    case RodzajZatrudnienia.Uczeń1Klasy:
                    case RodzajZatrudnienia.Uczeń2Klasy:
                    case RodzajZatrudnienia.Uczeń3Klasy:
                    case RodzajZatrudnienia.MłodocianyPrzyuczany:
                        return true;
                    default:
                        return false;
                }
            }
        }

        PrnParams pars;
        [Soneta.Business.Context(Required = true)]
        public PrnParams Params {
            set { pars = value; }
        }

        public class SrParams : SerializableContextBase {
            public SrParams(Context context) : base(context) {
            }

            bool pelneStanowisko = false;
            [Priority(1)]
            [Caption("Stanowisko pełna nazwa")]
            public bool PelneStanowisko {
                get { return pelneStanowisko; }
                set {
                    pelneStanowisko = value;
                    OnChanged(System.EventArgs.Empty);
                }
            }

            bool pelnaFunkcja = false;
            [Priority(2)]
            [Caption("Funkcja pełna nazwa")]
            public bool PelnaFunkcja {
                get { return pelnaFunkcja; }
                set {
                    pelnaFunkcja = value;
                    OnChanged(System.EventArgs.Empty);
                }
            }
        }

        SrParams srpars;
        [SettingsContext]
        public SrParams SrPars {
            get { return srpars; }
            set { srpars = value; }
        }

        OkresContext okresContext;
        [Soneta.Business.Context(Required = true)]
        public OkresContext OkresContext {
            set { okresContext = value; }
        }

        protected void dc_ContextLoad(object sender, System.EventArgs e) {
            FromTo okres = okresContext.Okres;
            Date data = okresContext.Aktualny;

            ReportHeader1["OKRES"] = (okres != FromTo.All) ? okres.ToString() : Str_OkresAll;

            switch (pars.Zakres) {
                case Zakres.Przyjęci:
                    ReportHeader1["CO"] = Str_Przyjetych;
                    break;
                case Zakres.Zwolnieni:
                    ReportHeader1["CO"] = Str_Zwolnionych;
                    break;
                default:
                    ReportHeader1["CO"] = Str_Zatrudnionych;
                    break;
            }

            switch (pars.Filtr) {
                case Filtr.Pracownicy:
                    ReportHeader1["KTO"] = Str_Pracownikow;
                    break;
                case Filtr.PracownicyMłodociani:
                    ReportHeader1["KTO"] = Str_Mlodocianych;
                    break;
                default:
                    ReportHeader1["KTO"] = Str_Wszystkich;
                    break;
            }

            // Odczytanie listy pracowników podległych z kontekstu
            Row[] rows = getRows();

            ArrayList result = new ArrayList();
            foreach (Pracownik idx in rows)
                if (pars.Test(idx, data, okres))
                    result.Add(idx);
            Grid1.DataSource = result;
        }

        protected void Grid1_BeforeRow(Object sender, Soneta.Web.RowEventArgs args) {
            PracHistoria ph = (PracHistoria)args.Row;

            System.Globalization.CultureInfo ci = new System.Globalization.CultureInfo(Str_CultureInfo);

            string col1str = ph.Nazwisko;
            if (ph.ImieDrugie != "")
                col1str += "\r\n" + ph.Imie + ", " + ph.ImieDrugie;
            else
                col1str += "\r\n" + ph.Imie;
            col1str += "\r\n" + ph.PESEL;
            col1str += "\r\n" + ph.Urodzony;
            col1.EditValue = col1str;

            string col2str = ph.Adres.ToString();
            col2str += "\r\n" + ph.AdresZameldowania.Telefon + ", " + ph.Dokument.SeriaNumer;
            RachunekBankowyPodmiotu rachunek = ((IPodmiotKasowy)ph.Pracownik).DomyslnyRachunek;
            if (rachunek != null) {
                if (rachunek.Rachunek.Bank != null)
                    col2str += "\r\n" + rachunek.Rachunek.Bank.Nazwa;
                else
                    col2str += "\r\n";
                col2str += "\r\n" + rachunek.Rachunek.Numer;
            }
            else
                col2str += "\r\n\r\n";
            col2.EditValue = col2str;

            string col3str = GetStanowisko(ph);
            col3str += "\r\n" + GetFunkcja(ph);
            col3str += "\r\n" + ph.Etat.OkresZatrudnienia.From;
            col3str += "\r\n" + CaptionAttribute.EnumToString(ph.Etat.RodzajZatrudnienia, ci);
            col3.EditValue = col3str;

            string col4str = "";
            try {
                if (ph.Etat.Zaszeregowanie.TypStawki == Soneta.Kadry.TypStawkiZaszeregowania.Minimalna)
                    col4str = Str_Minimalna;
                else
                    col4str = ph.Etat.Zaszeregowanie.Stawka.ToString();
            }
            catch (AccessException) {
            }
            try {
                col4str += "\r\n" + CaptionAttribute.EnumToString(ph.Etat.Zaszeregowanie.RodzajStawki, ci);
            }
            catch (AccessException) {
                col4str += "\r\n";
            }
            col4str += "\r\n" + ph.Etat.Wymiar;
            col4.EditValue = col4str;
        }

        string GetStanowisko(PracHistoria ph) {
            string stanowiskoPelne = "";
            if (srpars.PelneStanowisko)
                stanowiskoPelne = ph.Etat.StanowiskoPełne;
            if (stanowiskoPelne.Length == 0)
                stanowiskoPelne = ph.Etat.Stanowisko;
            return stanowiskoPelne;
        }

        string GetFunkcja(PracHistoria ph) {
            string funkcjaPelna = "";
            if (srpars.PelnaFunkcja)
                funkcjaPelna = ph.Etat.FunkcjaPełna;
            if (funkcjaPelna.Length == 0)
                funkcjaPelna = ph.Etat.Funkcja;
            return funkcjaPelna;
        }

        private Row[] getRows() {
            IWebUser wu = dc.Context.Login.WebUserOperatingInstance;
            if (wu == null)
                return (Row[])dc[typeof(Row[])];

            List<Pracownik> list = new List<Pracownik>();
            Pracownik[] result = null;

            PodwladniKalkulator kalkPodwladni = new PodwladniKalkulator(dc.Context, wu.Host.ID);
            KadryModule module = KadryModule.GetInstance(dc);
            Soneta.Business.View view = module.Pracownicy.WgNazwiska.CreateView();
            if (pars.Filtr != Filtr.Wszyscy) {
                // Warunek dla Etat
                RowCondition rcEtat = kalkPodwladni.FiltrEtatu(okresContext.Okres, null);
                // Pracownicy, Pracownicy młodociani (etat, umowa)
                view.Condition &= rcEtat;
                // Warunek dla Niezatrudnionych
                kalkPodwladni.UwzgledniajNiezatrudnionych = false;
            }
            else {
                // Warunek dla Niezatrudnionych
                kalkPodwladni.UwzgledniajNiezatrudnionych = true;
            }
            // Uwzględnij podwładnych
            IWebUser wo = dc.Context.Login.WebUserInstance;
            view.Condition &= kalkPodwladni.PrzeliczFiltr(wu==wo);
            view.ForceAllRows();
            foreach (Pracownik prac in view)
                list.Add(prac);
            result = list.ToArray();

            return result;
        }
    }
}
